﻿var modalDialog = {
    type: null,
    height: null,
    width: null,
    data: null,
    headerHeight: 40,
    footerHeight: 40,
    defaultConfirmWidth: 500,
    defaultConfirmHeight: 220,
    bodyDefaultPostitionValue: null,
    bodyDefaultOverflowValue: null,
    focusFirstField: true,
    beforeLoad: function () {
        var parent = a4.parent();

        //Reset the current data when opening the dialog
        modalDialog.data = null;

        //Increase size of parent to fit children bigger than parent
        if (parent != window.self && parent.modalDialog) {
            //var html = $('.fancybox-iframe').contents().find('html');
            var parentDocument = a4.parent().document;

            $(".fancybox-close", parentDocument).hide();

            var parentHeight = $(".fancybox-inner, .fancybox-wrap", parentDocument).height();
            var parentWidth = $(".fancybox-inner, .fancybox-wrap", parentDocument).width();

            if (parentHeight < modalDialog.height || parentWidth < modalDialog.width)
                $(".fancybox-inner, .fancybox-wrap", parentDocument).height(modalDialog.height + 50).width(modalDialog.width + 50);

            this.getTopWindow().reposition();
        }

        bodyDefaultOverflowValue = document.body.style.overflow;
        document.body.style.overflow = "hidden";
    },
    afterShow: function () {
        this.autoFocusFirstField();
        //var html = $('.fancybox-iframe').contents().find('html');
        //html.css("overflow", "hidden");
        //$(".content", html).height($(".content", html).height());
        //$(".content", html).width($(".content", html).width());
        //$(".content", html).mCustomScrollbar();
    },
    afterClose: function () {
        var parent = a4.parent();
        var parentModalDiabalog = parent.modalDialog;

        if (parent != window.self && parentModalDiabalog) {
            var parentDocument = parent.document;

            $(".fancybox-close", parentDocument).show();

            if (parentModalDiabalog.height < modalDialog.height || parentModalDiabalog.width < modalDialog.width)
                $(".fancybox-inner, .fancybox-wrap", parentDocument).height(parentModalDiabalog.height).width(parentModalDiabalog.width);

            this.getTopWindow().reposition();
        }

        document.body.style.overflow = bodyDefaultOverflowValue;
    },
    clearModernEditor: function () {
        //Tests IE
        //this.destroyAutoCompletes();

        if (!($.fancybox.inner == null || this.type == 'iframe')) {
            $(".modernEditor:last", $.fancybox.inner).remove();
        }
    },
    destroyAutoCompletes: function () {
        if (typeof (a4) != "undefined") {
            var autoCompletes = a4.top().autoCompletes;

            if (autoCompletes && $.fancybox.inner && $.fancybox.inner.length > 0) {
                _.each(autoCompletes[$.fancybox.inner[0].firstChild.name], function (autoComplete) {
                    autoComplete.destroy();
                });
            }
        }
    },
    autoFocusFirstField: function () {
        if (modalDialog.focusFirstField)
            $('.fancybox-iframe').contents().find(':input:visible:enabled:first').trigger("focus");
    },
    autoBind: function (cssClass, height, width) {
        this.type = 'iframe';

        if (!width)
            width = height * 1.618;

        $("." + cssClass).fancybox({
            type: 'iframe',
            padding: 0,
            autoSize: false,
            height: height,
            width: width,
            helpers: {
                overlay: {
                    closeClick: false
                }
            },
            beforeLoad: function () {
                modalDialog.beforeLoad();
            },
            afterShow: function () {
                modalDialog.autoFocusFirstField();
            },
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.afterClose();
            }
        });
    },
    showWindow: function (href, height, width, options) {
        this.type = 'iframe';
        this.height = height;
        this.width = width;

        var initFunction = null;
        var beforeClose = null;
        var afterClose = null;

        if (options) {
            if (options.initFunction)
                initFunction = options.initFunction;
            if (options.beforeClose)
                beforeClose = options.beforeClose;
            if (options.afterClose)
                afterClose = options.afterClose;
            if (typeof options.focusFirstField !== "undefined")
                modalDialog.focusFirstField = options.focusFirstField;
        }

        if (!width)
            width = height * 1.618;

        $.fancybox({
            type: 'iframe',
            href: href,
            padding: 0,
            closeBtn: !options || options.closeButton !== false,
            autoSize: false,
            height: height,
            width: width,
            //openEffect: 'none',
            //closeEffect: 'none',
            //nextEffect: 'none',
            //prevEffect: 'none',
            helpers: {
                overlay: {
                    closeClick: false
                }
            },
            beforeLoad: function () {
                modalDialog.beforeLoad();
            },
            afterShow: function () {
                if (initFunction) {
                    initFunction();
                }
                else {
                    modalDialog.autoFocusFirstField();
                }
            },
            beforeClose: function () {
                if (beforeClose) {
                    var result = beforeClose(modalDialog.data);

                    if (!result && result !== undefined) {
                        return false;
                    }
                }

                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.afterClose();

                if (afterClose) afterClose(modalDialog.data);
            }
        });
    },
    showHTML: function (href, height, width, options) {
        this.type = 'iframe';
        this.height = height;
        this.width = width;

        var afterClose = null;
        var beforeClose = null;

        if (options) {
            if (options.afterClose) {
                afterClose = options.afterClose;
            }

            if (options.beforeClose) {
                beforeClose = options.beforeClose;
            }
        }

        if (!width)
            width = height * 1.618;

        // Open a fancybox pop-up window with the "iframe" type and force content to the html value.
        $.fancybox({
            type: 'iframe',
            href: href,
            padding: 0,
            closeBtn: true,
            autoSize: false,
            height: height,
            width: width,
            helpers: {
                overlay: {
                    closeClick: false
                }
            },
            beforeShow: function () {
               modalDialog.beforeLoad();
            },
            afterShow: function () {
                modalDialog.autoFocusFirstField();
            },
            afterClose: function () {
                modalDialog.afterClose();

                if (afterClose) {
                    afterClose(modalDialog.data);
                }
            },
            beforeClose: function () {
                var iFrameId = document.getElementsByClassName('fancybox-iframe')[0].id;
                if (iFrameId) {
                    var iFrame = document.getElementById(iFrameId);
                    var iFrameWindow = iFrame && iFrame.contentWindow;  //Contains all methods that are present in iFrame
                    var iFrameDocument = iFrameWindow && (iFrameWindow.document || iFrame.contentDocument);  // Contains entire html of iFrame

                    if (beforeClose) {
                        beforeClose(iFrameWindow);
                    }
                }
            }
        });
    },
    showAjaxWindow: function (href, height, width, afterShow) {
        this.type = 'ajax';

        if (!width)
            width = height * 1.618;

        $.fancybox({
            type: 'ajax',
            href: href,
            padding: 0,
            autoSize: false,
            height: height,
            width: width,
            //openEffect: 'none',
            //closeEffect: 'none',
            //nextEffect: 'none',
            //prevEffect: 'none',
            helpers: {
                overlay: {
                    closeClick: false
                }
            },
            beforeShow: function () {
                modalDialog.beforeLoad();
            },
            afterShow: function () {
                afterShow();
            },
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.afterClose();
            }
        });
    },
    createDialogResources: function (message, title, checkBoxText, confirmButton) {
        return { "Message": message, "Title": title, "CheckBoxText": checkBoxText, "ConfirmButton": confirmButton };
    },
    showConfirmDialog: function (resources, yesFunction, height, width, addCheckboxConfirm, args, options) {
        var modernEditor = modalDialog.prepareHtmlForConfirmDialog(resources, yesFunction, addCheckboxConfirm, args, options);
        this.type = 'html';

        if (!width)
            width = modalDialog.defaultConfirmWidth;

        if (!height)
            height = modalDialog.defaultConfirmHeight + (addCheckboxConfirm ? 30 : 0);

        var initFunction = null;
        if (options && options.initFunction)
            initFunction = options.initFunction;

        $.fancybox({
            type: 'html',
            content: modernEditor,
            padding: 0,
            autoSize: false,
            width: width,
            height: height,
            closeBtn: false,
            keys: { close: null },
            beforeLoad: function () {
                modalDialog.beforeLoad();
            },
            afterShow: function () {
                if (initFunction)
                    initFunction();
            },
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.afterClose();
            },
            //openEffect: 'none',
            //closeEffect: 'none',
            //nextEffect: 'none',
            //prevEffect: 'none',
            helpers:
            {
                overlay: {
                    locked: true,
                    closeClick: false
                }
            }
        });
    },
    showConfirmDelete: function (resources, yesFunction, count) {
        var modernEditor = $('<div class="modernEditor confirm-dialog" />');
        var havePlurial = resources["PlurialName"] != null;

        var objectName = resources["SingularName"];
        if (havePlurial && count != 1) {
            objectName = resources["PlurialName"];
        }
        var args = { "count": count, "title": objectName, object: objectName.toLowerCase() };
        
        var title = havePlurial? confirmDeleteResources.Title: confirmDeleteResources.Titles;
        var titleContent = "";
        if (title) {
            if (args) {
                title = title.replace(/{(.*?)}/g, function (group, value) {
                    return args[value];
                });
            }

            titleContent = title;
        }

        var editorHeader = $('<div class="header" />');
        editorHeader.append($('<div class=\"title\">').html(titleContent));
        modernEditor.append(editorHeader);

        var message = havePlurial ? confirmDeleteResources.MessageDynamic : confirmDeleteResources.MessageGeneric;
        if (args) {
            message = message.replace(/{(.*?)}/g, function (group, value) {
                return args[value];
            });
        }

        var editorContent = $('<div class="content" />');
        var editorWrappedContent = $('<div class="wrapper" />').html(message);

        editorContent.append(editorWrappedContent);

        var confirmCheckBox = $('<input id="confirmCheck" type="checkbox" />');

        var checkBoxText = havePlurial ? confirmDeleteResources.CheckBoxTextDynamic : confirmDeleteResources.CheckBoxTextGeneric;
        checkBoxText = checkBoxText.replace(/{(.*?)}/g, function (group, value) {
                return args[value];
            });

        editorWrappedContent.append($('<div class="confirmCheck" />')
                        .append(confirmCheckBox)
                        .append($('<label for="confirmCheck"/>').html(checkBoxText))
                     );
        
        modernEditor.append(editorContent);

        var initFunction = null;
        var validateFunction = null;
        var cancelFunction = null;
        var saveButtonText = confirmDeleteResources.ConfirmButton;
        var cancelButtonText = confirmDeleteResources.Cancel;
        
        var saveButton = $('<span />', { "class": "button primary button-confirm" }).text(saveButtonText).on("click",
            function () {
                if (!$(this).prop("disabled")) {
                    var valid = (validateFunction == null || validateFunction());
                    var param = $("#optionCheck").is(":checked");

                    if (valid) {
                        yesFunction(param);
                        modalDialog.close();
                    }
                }
            });

        var cancelButton = $('<span />', { "class": "link-button button-cancel" }).text(confirmDeleteResources.CancelButton).on("click",
            function () {
                if (cancelFunction) {
                    cancelFunction();
                }
                modalDialog.close();
            });

        if (confirmCheckBox) {
            saveButton.prop('disabled', true);
            saveButton.addClass("disabled");
            confirmCheckBox.on("change", function () {
                var checked = $(this).prop('checked');
                saveButton.prop('disabled', !checked);
                saveButton.toggleClass("disabled", !checked);
            });
        }

        var editorFooter = $('<div class="footer" />').append(saveButton);
        editorFooter = editorFooter.append(cancelButton);
        modernEditor.append(editorFooter);

        this.type = 'html';

        var width = modalDialog.defaultConfirmWidth;
        var height = modalDialog.defaultConfirmHeight + 30;

        $.fancybox({
            type: 'html',
            content: modernEditor,
            padding: 0,
            autoSize: false,
            width: width,
            height: height,
            closeBtn: false,
            keys: { close: null },
            beforeLoad: function () {
                modalDialog.beforeLoad();
            },
            afterShow: function () {
                if (initFunction)
                    initFunction();
            },
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.afterClose();
            },
            helpers:
            {
                overlay: {
                    locked: true,
                    closeClick: false
                }
            }
        });
    },
    showCustomDialog: function (message, title, buttons, height, width, closeBtn) {
        var modernEditor = $('<div class="modernEditor" />');

        var editorHeader = $('<div class="header" />');
        editorHeader.append($('<div class=\"title\">').html(title));
        modernEditor.append(editorHeader);

        var editorContent = $('<div class="content" />');
        var editorWrappedContent = $('<div class="wrapper" />').html(message);

        editorContent.append(editorWrappedContent);

        modernEditor.append(editorContent);

        var editorFooter = $('<div class="footer" />');

        _.each(buttons, function (button) {
            var saveButton = $('<span />', { "class": button.LinkButton ? "link-button" : "button" });

            if (button.CssClass)
                saveButton.addClass(button.CssClass);

            saveButton.text(button.Text);

            saveButton.on("click", function () {
                if (button.Action && _.isFunction(button.Action))
                    button.Action();

                modalDialog.close();
            });

            editorFooter.append(saveButton);
        });

        modernEditor.append(editorFooter);

        this.type = 'html';

        $.fancybox({
            type: 'html',
            content: modernEditor,
            padding: 0,
            autoSize: false,
            width: width || modalDialog.defaultConfirmWidth,
            height: height || modalDialog.defaultConfirmHeight,
            closeBtn: closeBtn || false,
            beforeLoad: function () {
                modalDialog.beforeLoad();
            },
            //afterShow: function () {
            //    if (initFunction)
            //        initFunction();
            //},
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.afterClose();
            },
            helpers:
            {
                overlay: {
                    locked: true,
                    closeClick: false
                }
            }
        });
    },
    showRequiredActionDialog: function (resources, yesFunction, noFunction, height, width, showClose) {
        modalDialog.showConfirmDialog(resources, yesFunction, height, width, null, null, { cancel: noFunction, showCloseButton: showClose, saveButtonText: resources['SaveButtonText'], cancelButtonText: resources['CancelButtonText'] });
    },
    showUnsavedChangesDialog: function (saveFunction, discardFunction, cancelFunction) {
        if (!cancelFunction)
            cancelFunction = function () { modalDialog.close(); };

        var buttons = [
            { Text: sharedResources.Save, CssClass: "primary", Action: saveFunction },
            { Text: sharedResources.DontSave, Action: discardFunction },
            { Text: sharedResources.Cancel, LinkButton: true, Action: cancelFunction }
        ];

        modalDialog.showCustomDialog(unsavedChangesResources.Message, unsavedChangesResources.Title, buttons);
    },
    renderSimpleFormDialog: function (resources, inputs, saveFunction) {
        var modernEditor = $('<div class="modernEditor" />');
        var inputsHeight = 0;

        var editorHeader = $('<div class="header" />');
        editorHeader.append($('<div class=\"title\">').html(resources["Title"]));
        modernEditor.append(editorHeader);

        var editorContent = $('<div class="content" />');

        _.each(inputs, function (input) {
            var editorField = $('<div />', { "class": "field clearfix" });
            var fieldClass = "";

            if (typeof input.Label !== "undefined" && !(input.Label === null)) {
                editorField.append($('<div />', { "class": "label" }).html(input.Label));
                fieldClass = "inputField";
            }

            var inputStyle = typeof input.Style !== "undefined" ? input.Style : "";

            if (typeof input.Type !== "undefined" && input.Type == "textarea") {
                editorField.append($('<div />', { "class": fieldClass }).append($('<textarea />', { "style": "height:300px;" + inputStyle, "data-fieldname": input.Name }).val(input.Value)));
                inputsHeight += 310;
            } else {
                editorField.append($('<div />', { "class": fieldClass }).append($('<input />', { "type": "text", "data-fieldname": input.Name }).val(input.Value)));
                inputsHeight += 45;
            }

            editorContent.append(editorField);
        });

        modernEditor.append(editorContent);

        var confirmButton = resources["ConfirmButton"] ? $('<span />', { "class": "button primary" }).html(resources["ConfirmButton"]).on("click", function () {
            var items = {};
            $(".field input, .field textarea", modernEditor).each(function () {
                items[$(this).attr("data-fieldname")] = $(this).val();
            });

            saveFunction(items);
            modalDialog.close();
        }) : $('<span />');

        var cancelButton = $('<span />', { 'class': 'link-button' }).html(resources["CancelButton"]).on("click", function () { modalDialog.close(); });

        var editorFooter = $('<div class="footer" />').append(confirmButton).append(cancelButton)
        modernEditor.append(editorFooter);

        this.type = 'html';

        $.fancybox({
            type: 'html',
            content: modernEditor,
            padding: 0,
            width: 500,
            height: 98 + inputsHeight,
            autoSize: false,
            //openEffect: 'none',
            //closeEffect: 'none',
            //nextEffect: 'none',
            //prevEffect: 'none',
            beforeLoad: function () {
                modalDialog.beforeLoad();
            },
            afterShow: function () {
                $('.modernEditor').find(':input:visible:enabled:first').trigger("focus");
            },
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.afterClose();
            }
        });
    },
    getTopWindow: function () {
        var window;

        if ($.fancybox.inner == null || this.type == 'iframe') {
            window = a4.parent().$.fancybox;
        }
        else {
            window = $.fancybox;
        }

        return window;
    },
    getTopDialog: function () {
        var topDialog = $('.fancybox-iframe').contents();

        while ($('.fancybox-iframe', topDialog).length > 0) {
            topDialog = $('.fancybox-iframe', topDialog).contents();
        }

        return topDialog;
    },
    close: function (data) {
        var parent = a4.parent();
        var parentModalDiabalog = parent.modalDialog;
        parentModalDiabalog.data = data;

        this.getTopWindow().close();
        return false;
    },
    resize: function (height, width) {
        if (height || width) {
            var fancybox = this.getTopWindow();

            var outer = $(".fancybox-wrap", a4.parent().document);
            var inner = $(".fancybox-inner", a4.parent().document);

            if (fancybox.current) {
                if (height) {
                    outer.height(height);
                    inner.height(height);

                    fancybox.current.height = height;
                }

                if (width) {
                    outer.width(width);
                    inner.width(width);

                    fancybox.current.width = width;
                }
            }

            fancybox.reposition();
        }
    },
    setButtonState: function (saveButton, checkBox) {
        saveButton.prop('disabled', true);
        saveButton.addClass("disabled");

        checkBox.on("change", function () {
            var checked = $(this).prop('checked');
            saveButton.prop('disabled', !checked);
            saveButton.toggleClass("disabled", !checked);
        });
    },
    closeModalWindows: function () {
        modalDialog.close();

        var topWindow = modalDialog.getTopWindow();

        if (topWindow.wrap.length > 0) {
            var isFancyBoxWrap = topWindow.wrap[0].classList.value.split(' ').filter(cls => cls.toLowerCase().includes('fancybox-wrap'));

            if (isFancyBoxWrap.length > 0) {
                modalDialog.close();
            }
        }
    },
    prepareHtmlForConfirmDialog: function (resources, yesFunction, addCheckboxConfirm, args, options) {
        var modernEditor = $('<div class="modernEditor confirm-dialog" />');

        var title = resources["Title"];
        var titleContent = "";
        if (title) {
            if (args) {
                title = title.replace(/{(.*?)}/g, function (group, value) {
                    return args[value];
                });
            }

            titleContent = title;
        }

        var editorHeader = $('<div class="header" />');
        editorHeader.append($('<div class=\"title\">').html(titleContent));
        modernEditor.append(editorHeader);

        var message = resources["Message"];
        if (args) {
            message = message.replace(/{(.*?)}/g, function (group, value) {
                return args[value];
            });
        }

        var editorContent = $('<div class="content" />');
        var editorWrappedContent = $('<div class="wrapper" />').html(message);

        editorContent.append(editorWrappedContent);

        var confirmCheckBox;
        var checkboxText = resources["CheckBoxText"];
        if (args && checkboxText) {
            checkboxText = checkboxText.replace(/{(.*?)}/g, function (group, value) {
                return args[value];
            });
        }

        if (addCheckboxConfirm) {
            confirmCheckBox = $('<input id="confirmCheck" type="checkbox" />');
            editorWrappedContent.append($('<div class="confirmCheck" />')
                .append(confirmCheckBox)
                .append($('<label for="confirmCheck"/>').html(checkboxText))
            );
        }

        var optionCheckBox;

        if (options && options.additionalCheckbox) {
            var optionText = resources["OptionText"];
            if (args) {
                optionText = optionText.replace(/{(.*?)}/g, function (group, value) {
                    return args[value];
                });
            }

            optionCheckBox = $('<input id="optionCheck" type="checkbox" />');
            editorWrappedContent.append($('<div class="optionCheck" />')
                .append(optionCheckBox)
                .append($('<label for="optionCheck"/>').html(optionText))
            );
        }

        modernEditor.append(editorContent);

        var validateFunction = null;
        var cancelFunction = null;
        var cancelButtonText = sharedResources.Cancel;
        var closeButtonText = sharedResources.Cancel;
        var showCancelButton = true;
        var showCloseButton = false;
        var closeOnConfirm = true;
        var confirmButtonClassName = "button-confirm";
        var confirmButtonType = args && args["confirmButtonType"] ? args["confirmButtonType"] : "primary";
        var saveButtonText = resources["ConfirmButton"] ? resources["ConfirmButton"] : sharedResources.Confirm;
        if (args) {
            saveButtonText = saveButtonText.replace(/{(.*?)}/g, function (group, value) {
                return args[value];
            });
        }

        if (options) {
            if (options.cancel)
                cancelFunction = options.cancel;

            if (options.saveButtonText)
                saveButtonText = options.saveButtonText;

            if (options.cancelButtonText)
                cancelButtonText = options.cancelButtonText;

            if (options.cancelFunction)
                cancelFunction = options.cancelFunction;

            if (options.validateFunction)
                validateFunction = options.validateFunction;

            if (options.hideCancelButton)
                showCancelButton = !options.hideCancelButton;

            if (options.showCloseButton)
                showCloseButton = options.showCloseButton;

            if (typeof options.closeOnConfirm != 'undefined')
                closeOnConfirm = options.closeOnConfirm;

            if (options.confirmButtonClassName)
                confirmButtonClassName = options.confirmButtonClassName;
        }

        var saveButton = $('<span />', { "class": ("button " + confirmButtonType + " " + confirmButtonClassName) }).text(saveButtonText).on("click",
            function () {
                if (!$(this).prop("disabled")) {
                    var valid = (validateFunction == null || validateFunction());
                    var param = $("#optionCheck").is(":checked");

                    if (valid) {
                        yesFunction(param);

                        if (closeOnConfirm) {
                            modalDialog.closeModalWindows()
                        }
                    }
                }
            });

        var cancelButton = $('<span />', { "class": "link-button button-cancel" }).text(cancelButtonText).on("click",
            function () {
                if (cancelFunction) {
                    cancelFunction();
                }
                modalDialog.close();
            });

        if (confirmCheckBox) {
            modalDialog.setButtonState(saveButton, confirmCheckBox);
        }

        if (optionCheckBox) {
            modalDialog.setButtonState(saveButton, optionCheckBox);
        }

        var editorFooter = $('<div class="footer" />').append(saveButton);

        if (showCancelButton) {
            editorFooter = editorFooter.append(cancelButton);
        }

        if (showCloseButton) {
            var closeButton = $('<span />', { "class": "link-button button-close" }).text(closeButtonText).on("click", function () { modalDialog.close(); });

            editorFooter = editorFooter.append(closeButton);
        }

        modernEditor.append(editorFooter);
        return modernEditor;
    }
};
